# coding: utf-8

"""
    SendinBlue API

    SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@sendinblue.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sib_api_v3_sdk.api_client import ApiClient


class WebhooksApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_webhook(self, create_webhook, **kwargs):  # noqa: E501
        """Create a webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_webhook(create_webhook, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateWebhook create_webhook: Values to create a webhook (required)
        :return: CreateModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_webhook_with_http_info(create_webhook, **kwargs)  # noqa: E501
        else:
            (data) = self.create_webhook_with_http_info(create_webhook, **kwargs)  # noqa: E501
            return data

    def create_webhook_with_http_info(self, create_webhook, **kwargs):  # noqa: E501
        """Create a webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_webhook_with_http_info(create_webhook, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateWebhook create_webhook: Values to create a webhook (required)
        :return: CreateModel
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['create_webhook']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_webhook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'create_webhook' is set
        if ('create_webhook' not in params or
                params['create_webhook'] is None):
            raise ValueError("Missing the required parameter `create_webhook` when calling `create_webhook`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_webhook' in params:
            body_params = params['create_webhook']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/webhooks', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_webhook(self, webhook_id, **kwargs):  # noqa: E501
        """Delete a webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_webhook(webhook_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int webhook_id: Id of the webhook (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_webhook_with_http_info(webhook_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_webhook_with_http_info(webhook_id, **kwargs)  # noqa: E501
            return data

    def delete_webhook_with_http_info(self, webhook_id, **kwargs):  # noqa: E501
        """Delete a webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_webhook_with_http_info(webhook_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int webhook_id: Id of the webhook (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_webhook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook_id' is set
        if ('webhook_id' not in params or
                params['webhook_id'] is None):
            raise ValueError("Missing the required parameter `webhook_id` when calling `delete_webhook`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'webhook_id' in params:
            path_params['webhookId'] = params['webhook_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/webhooks/{webhookId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_webhook(self, webhook_id, **kwargs):  # noqa: E501
        """Get a webhook details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhook(webhook_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int webhook_id: Id of the webhook (required)
        :return: GetWebhook
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_webhook_with_http_info(webhook_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_webhook_with_http_info(webhook_id, **kwargs)  # noqa: E501
            return data

    def get_webhook_with_http_info(self, webhook_id, **kwargs):  # noqa: E501
        """Get a webhook details  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhook_with_http_info(webhook_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int webhook_id: Id of the webhook (required)
        :return: GetWebhook
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webhook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook_id' is set
        if ('webhook_id' not in params or
                params['webhook_id'] is None):
            raise ValueError("Missing the required parameter `webhook_id` when calling `get_webhook`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'webhook_id' in params:
            path_params['webhookId'] = params['webhook_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/webhooks/{webhookId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetWebhook',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_webhooks(self, **kwargs):  # noqa: E501
        """Get all webhooks  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhooks(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: Filter on webhook type
        :param str sort: Sort the results in the ascending/descending order of webhook creation
        :return: GetWebhooks
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_webhooks_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_webhooks_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_webhooks_with_http_info(self, **kwargs):  # noqa: E501
        """Get all webhooks  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_webhooks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: Filter on webhook type
        :param str sort: Sort the results in the ascending/descending order of webhook creation
        :return: GetWebhooks
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'sort']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_webhooks" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/webhooks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetWebhooks',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_webhook(self, webhook_id, update_webhook, **kwargs):  # noqa: E501
        """Update a webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_webhook(webhook_id, update_webhook, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int webhook_id: Id of the webhook (required)
        :param UpdateWebhook update_webhook: Values to update a webhook (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_webhook_with_http_info(webhook_id, update_webhook, **kwargs)  # noqa: E501
        else:
            (data) = self.update_webhook_with_http_info(webhook_id, update_webhook, **kwargs)  # noqa: E501
            return data

    def update_webhook_with_http_info(self, webhook_id, update_webhook, **kwargs):  # noqa: E501
        """Update a webhook  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_webhook_with_http_info(webhook_id, update_webhook, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int webhook_id: Id of the webhook (required)
        :param UpdateWebhook update_webhook: Values to update a webhook (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['webhook_id', 'update_webhook']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_webhook" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'webhook_id' is set
        if ('webhook_id' not in params or
                params['webhook_id'] is None):
            raise ValueError("Missing the required parameter `webhook_id` when calling `update_webhook`")  # noqa: E501
        # verify the required parameter 'update_webhook' is set
        if ('update_webhook' not in params or
                params['update_webhook'] is None):
            raise ValueError("Missing the required parameter `update_webhook` when calling `update_webhook`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'webhook_id' in params:
            path_params['webhookId'] = params['webhook_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_webhook' in params:
            body_params = params['update_webhook']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/webhooks/{webhookId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
