# coding: utf-8

"""
    SendinBlue API

    SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@sendinblue.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class CreateUpdateProducts(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'url': 'str',
        'image_url': 'str',
        'sku': 'str',
        'price': 'float',
        'categories': 'list[str]',
        'parent_id': 'str',
        'meta_info': 'dict(str, str)',
        'deleted_at': 'str'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'url': 'url',
        'image_url': 'imageUrl',
        'sku': 'sku',
        'price': 'price',
        'categories': 'categories',
        'parent_id': 'parentId',
        'meta_info': 'metaInfo',
        'deleted_at': 'deletedAt'
    }

    def __init__(self, id=None, name=None, url=None, image_url=None, sku=None, price=None, categories=None, parent_id=None, meta_info=None, deleted_at=None):  # noqa: E501
        """CreateUpdateProducts - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._name = None
        self._url = None
        self._image_url = None
        self._sku = None
        self._price = None
        self._categories = None
        self._parent_id = None
        self._meta_info = None
        self._deleted_at = None
        self.discriminator = None

        self.id = id
        self.name = name
        if url is not None:
            self.url = url
        if image_url is not None:
            self.image_url = image_url
        if sku is not None:
            self.sku = sku
        if price is not None:
            self.price = price
        if categories is not None:
            self.categories = categories
        if parent_id is not None:
            self.parent_id = parent_id
        if meta_info is not None:
            self.meta_info = meta_info
        if deleted_at is not None:
            self.deleted_at = deleted_at

    @property
    def id(self):
        """Gets the id of this CreateUpdateProducts.  # noqa: E501

        Product ID for which you requested the details  # noqa: E501

        :return: The id of this CreateUpdateProducts.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CreateUpdateProducts.

        Product ID for which you requested the details  # noqa: E501

        :param id: The id of this CreateUpdateProducts.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def name(self):
        """Gets the name of this CreateUpdateProducts.  # noqa: E501

        Mandatory in case of creation**. Name of the product for which you requested the details  # noqa: E501

        :return: The name of this CreateUpdateProducts.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreateUpdateProducts.

        Mandatory in case of creation**. Name of the product for which you requested the details  # noqa: E501

        :param name: The name of this CreateUpdateProducts.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def url(self):
        """Gets the url of this CreateUpdateProducts.  # noqa: E501

        URL to the product  # noqa: E501

        :return: The url of this CreateUpdateProducts.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this CreateUpdateProducts.

        URL to the product  # noqa: E501

        :param url: The url of this CreateUpdateProducts.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def image_url(self):
        """Gets the image_url of this CreateUpdateProducts.  # noqa: E501

        Absolute URL to the cover image of the product  # noqa: E501

        :return: The image_url of this CreateUpdateProducts.  # noqa: E501
        :rtype: str
        """
        return self._image_url

    @image_url.setter
    def image_url(self, image_url):
        """Sets the image_url of this CreateUpdateProducts.

        Absolute URL to the cover image of the product  # noqa: E501

        :param image_url: The image_url of this CreateUpdateProducts.  # noqa: E501
        :type: str
        """

        self._image_url = image_url

    @property
    def sku(self):
        """Gets the sku of this CreateUpdateProducts.  # noqa: E501

        Product identifier from the shop  # noqa: E501

        :return: The sku of this CreateUpdateProducts.  # noqa: E501
        :rtype: str
        """
        return self._sku

    @sku.setter
    def sku(self, sku):
        """Sets the sku of this CreateUpdateProducts.

        Product identifier from the shop  # noqa: E501

        :param sku: The sku of this CreateUpdateProducts.  # noqa: E501
        :type: str
        """

        self._sku = sku

    @property
    def price(self):
        """Gets the price of this CreateUpdateProducts.  # noqa: E501

        Price of the product  # noqa: E501

        :return: The price of this CreateUpdateProducts.  # noqa: E501
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price):
        """Sets the price of this CreateUpdateProducts.

        Price of the product  # noqa: E501

        :param price: The price of this CreateUpdateProducts.  # noqa: E501
        :type: float
        """

        self._price = price

    @property
    def categories(self):
        """Gets the categories of this CreateUpdateProducts.  # noqa: E501

        Category ID-s of the product  # noqa: E501

        :return: The categories of this CreateUpdateProducts.  # noqa: E501
        :rtype: list[str]
        """
        return self._categories

    @categories.setter
    def categories(self, categories):
        """Sets the categories of this CreateUpdateProducts.

        Category ID-s of the product  # noqa: E501

        :param categories: The categories of this CreateUpdateProducts.  # noqa: E501
        :type: list[str]
        """

        self._categories = categories

    @property
    def parent_id(self):
        """Gets the parent_id of this CreateUpdateProducts.  # noqa: E501

        Parent product id of the product  # noqa: E501

        :return: The parent_id of this CreateUpdateProducts.  # noqa: E501
        :rtype: str
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """Sets the parent_id of this CreateUpdateProducts.

        Parent product id of the product  # noqa: E501

        :param parent_id: The parent_id of this CreateUpdateProducts.  # noqa: E501
        :type: str
        """

        self._parent_id = parent_id

    @property
    def meta_info(self):
        """Gets the meta_info of this CreateUpdateProducts.  # noqa: E501

        Meta data of product such as description, vendor, producer, stock level. The size of cumulative metaInfo shall not exceed **1000 KB**. Maximum length of metaInfo object can be 10.  # noqa: E501

        :return: The meta_info of this CreateUpdateProducts.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._meta_info

    @meta_info.setter
    def meta_info(self, meta_info):
        """Sets the meta_info of this CreateUpdateProducts.

        Meta data of product such as description, vendor, producer, stock level. The size of cumulative metaInfo shall not exceed **1000 KB**. Maximum length of metaInfo object can be 10.  # noqa: E501

        :param meta_info: The meta_info of this CreateUpdateProducts.  # noqa: E501
        :type: dict(str, str)
        """

        self._meta_info = meta_info

    @property
    def deleted_at(self):
        """Gets the deleted_at of this CreateUpdateProducts.  # noqa: E501

        UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) of the product deleted from the shop's database  # noqa: E501

        :return: The deleted_at of this CreateUpdateProducts.  # noqa: E501
        :rtype: str
        """
        return self._deleted_at

    @deleted_at.setter
    def deleted_at(self, deleted_at):
        """Sets the deleted_at of this CreateUpdateProducts.

        UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) of the product deleted from the shop's database  # noqa: E501

        :param deleted_at: The deleted_at of this CreateUpdateProducts.  # noqa: E501
        :type: str
        """

        self._deleted_at = deleted_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateUpdateProducts, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateUpdateProducts):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
