# coding: utf-8

"""
    SendinBlue API

    SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@sendinblue.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Task(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'task_type_id': 'str',
        'name': 'str',
        'contacts_ids': 'list[int]',
        'deals_ids': 'list[str]',
        'companies_ids': 'list[str]'
    }

    attribute_map = {
        'id': 'id',
        'task_type_id': 'taskTypeId',
        'name': 'name',
        'contacts_ids': 'contactsIds',
        'deals_ids': 'dealsIds',
        'companies_ids': 'companiesIds'
    }

    def __init__(self, id=None, task_type_id=None, name=None, contacts_ids=None, deals_ids=None, companies_ids=None):  # noqa: E501
        """Task - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._task_type_id = None
        self._name = None
        self._contacts_ids = None
        self._deals_ids = None
        self._companies_ids = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.task_type_id = task_type_id
        self.name = name
        if contacts_ids is not None:
            self.contacts_ids = contacts_ids
        if deals_ids is not None:
            self.deals_ids = deals_ids
        if companies_ids is not None:
            self.companies_ids = companies_ids

    @property
    def id(self):
        """Gets the id of this Task.  # noqa: E501

        Unique task id  # noqa: E501

        :return: The id of this Task.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Task.

        Unique task id  # noqa: E501

        :param id: The id of this Task.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def task_type_id(self):
        """Gets the task_type_id of this Task.  # noqa: E501

        Id for type of task e.g Call / Email / Meeting etc.  # noqa: E501

        :return: The task_type_id of this Task.  # noqa: E501
        :rtype: str
        """
        return self._task_type_id

    @task_type_id.setter
    def task_type_id(self, task_type_id):
        """Sets the task_type_id of this Task.

        Id for type of task e.g Call / Email / Meeting etc.  # noqa: E501

        :param task_type_id: The task_type_id of this Task.  # noqa: E501
        :type: str
        """
        if task_type_id is None:
            raise ValueError("Invalid value for `task_type_id`, must not be `None`")  # noqa: E501

        self._task_type_id = task_type_id

    @property
    def name(self):
        """Gets the name of this Task.  # noqa: E501

        Name of task  # noqa: E501

        :return: The name of this Task.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Task.

        Name of task  # noqa: E501

        :param name: The name of this Task.  # noqa: E501
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def contacts_ids(self):
        """Gets the contacts_ids of this Task.  # noqa: E501

        Contact ids for contacts linked to this task  # noqa: E501

        :return: The contacts_ids of this Task.  # noqa: E501
        :rtype: list[int]
        """
        return self._contacts_ids

    @contacts_ids.setter
    def contacts_ids(self, contacts_ids):
        """Sets the contacts_ids of this Task.

        Contact ids for contacts linked to this task  # noqa: E501

        :param contacts_ids: The contacts_ids of this Task.  # noqa: E501
        :type: list[int]
        """

        self._contacts_ids = contacts_ids

    @property
    def deals_ids(self):
        """Gets the deals_ids of this Task.  # noqa: E501

        Deal ids for deals a task is linked to  # noqa: E501

        :return: The deals_ids of this Task.  # noqa: E501
        :rtype: list[str]
        """
        return self._deals_ids

    @deals_ids.setter
    def deals_ids(self, deals_ids):
        """Sets the deals_ids of this Task.

        Deal ids for deals a task is linked to  # noqa: E501

        :param deals_ids: The deals_ids of this Task.  # noqa: E501
        :type: list[str]
        """

        self._deals_ids = deals_ids

    @property
    def companies_ids(self):
        """Gets the companies_ids of this Task.  # noqa: E501

        Companies ids for companies a task is linked to  # noqa: E501

        :return: The companies_ids of this Task.  # noqa: E501
        :rtype: list[str]
        """
        return self._companies_ids

    @companies_ids.setter
    def companies_ids(self, companies_ids):
        """Sets the companies_ids of this Task.

        Companies ids for companies a task is linked to  # noqa: E501

        :param companies_ids: The companies_ids of this Task.  # noqa: E501
        :type: list[str]
        """

        self._companies_ids = companies_ids

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Task, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Task):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
