from django.contrib import admin
from .models import CreativeDetails , Blog , Events , UserProfile

class CreativeDetailsAdmin(admin.ModelAdmin):
    list_display = ('full_name','email', 'profession')
    search_fields = ('full_name','email', 'profession')

admin.site.register(CreativeDetails, CreativeDetailsAdmin)

class BlogAdmin(admin.ModelAdmin):
    list_display = ('title','published_date')
    search_fields = ('title','published_date')

admin.site.register(Blog, BlogAdmin)

class EventsAdmin(admin.ModelAdmin):
    list_display = ('name','date','time')
    search_fields = ('name','date','time')

admin.site.register(Events, EventsAdmin)

class UserProfileAdmin(admin.ModelAdmin):
    list_display = ('full_name','profession')
    search_fields = ('full_name','profession')

admin.site.register(UserProfile, UserProfileAdmin)


# class CustomUserAdmin(admin.ModelAdmin):
#     model = CustomUser 
#     list_display = ('email', 'first_name', 'last_name','profession')
#     list_filter = ('is_staff', 'is_active')
#     ordering = ('email',)

# admin.site.register(CustomUser , CustomUserAdmin)