# forms.py
from django import forms
from .models import CreativeDetails , UserProfile  ,Comment
from django.contrib.auth.forms import UserCreationForm
from django.contrib.auth import get_user_model
from django.contrib.auth.models import User


class CreativeDetailsForm(forms.ModelForm):
    class Meta:
        model = CreativeDetails
        fields = (
            'full_name', 
            'date_of_birth', 
            'email', 
            'bio',
            'gender', 
            'phone_number', 
            'address', 
            'parish', 
            'social_media_handles', 
            'diocese', 
            'profile_picture', 
            'profession', 
            'primary_creative_area', 
            'secondary_creative_area', 
            'years_of_experience', 
            'projects', 
            'freelance_or_professional', 
            'why_are_you_joining_us', 
            'what_do_you_want_to_achieve', 
            'what_value_would_your_talent_contribute_to_us', 
            'how_do_you_hope_to_integrate_your_skills_to_us', 
            'in_what_capacity_would_you_be_involved_in', 
            'would_you_be_interested_in_being_mentored', 
            'would_you_mentor_others', 
            'if_interested_what_area_would_you_be_mentored_in', 
            'list_any_mentors_or_programs', 
            'do_you_have_existing_affiliations_with_any_creative_society',
            'would_you_collaborate',
            'would_you_be_interested_with_leadership_roles',
            'how_do_you_prefer_to_receive_updates',
            'website_or_portfolio',
            'instagram',
            'youtube',
            'other_platforms',
            'consent_for_media_use',
            'code_of_conduct',
            'commitment_to_the_community',
        )
        
        CREATIVE_AREA_CHOICES = [
            ('writing', 'Writing'),
            ('photography', 'Photography'),
            ('graphic design', 'Graphic Design'),
            ('musician', 'Musician'),
            ('video production', 'Video Production'),
            ('acting', 'Acting/Performance'),
            ('spoken word', 'Spoken Word Artist'),
            ('tech', 'Technology'),
            ('visual artist', 'Visual Artist'),
            ('fashion/costume designer', 'Fashion/Costume Designer'),
            ('choreography(dance)', 'Choreography(Dance)'),
        ]
        
        YEARS_OF_EXPERIENCE = [
            ('0-1', '0-1 years'),
            ('2-5', '2-5 years'),
            ('6-10', '6-10 years'),
            ('over 10 years', 'Over 10 years'),
        ]
        
        SIMPLE_CHOICES = [
            ('Yes', 'Yes'),
            ('No', 'No'),
        ]
        
        WHAT_WAY_TO_BE_INVOLVED = [
            ('Active Member', 'Active Member'),
            ('Collaborator', 'Collaborator'),
            ('Leadership Role', 'Leadership Role'),
            ('Volunteer', 'Volunteer'),
            ('Mentor', 'Mentor'),
        ]
        
        UPDATES_PREFERENCE = [
            ('Email', 'Email'),
            ('Whatsapp', 'Whatsapp'),
            ('Social Media', 'Social Media'),
        ]
        
        widgets = {
            'full_name': forms.TextInput(attrs={'class': 'form-control'}),
            'date_of_birth': forms.DateInput(attrs={'class': 'form-control'}),
            'email': forms.EmailInput(attrs={'class': 'form-control'}),
            'bio': forms.Textarea(attrs={'class': 'form-control'}),
            'gender': forms.TextInput(attrs={'class': 'form-control'}),
            'phone_number': forms.NumberInput(attrs={'class': 'form-control'}),
            'home_address': forms.TextInput(attrs={'class': 'form-control'}),
            'parish': forms.TextInput(attrs={'class': 'form-control'}),
            'social_media_handles': forms.TextInput(attrs={'class': 'form-control'}),
            'diocese': forms.TextInput(attrs={'class': 'form-control'}),
            'profile_picture': forms.FileInput(attrs={'class': 'form-control'}),
            'profession': forms.TextInput(attrs={'class': 'form-control'}),
            'primary_creative_area': forms.TextInput(attrs={'class': 'form-control'}),
            'secondary_creative_area': forms.TextInput(attrs={'class': 'form-control'}),
            'years_of_experience': forms.TextInput(attrs={'class': 'form-control'}),
            'projects': forms.Textarea(attrs={'class': 'form-control'}),
            'freelance_or_professional': forms.TextInput(attrs={'class': 'form-control'}),
            'why_are_you_joining_us': forms.Textarea(attrs={'class': 'form-control'}),
            'what_do_you_want_to_achieve': forms.Textarea(attrs={'class': 'form-control'}),
            ' what_value_would_your_talent_contribute_to_us': forms.Textarea(attrs={'class': 'form-control'}),
            'how_do_you_hope_to_integrate_your_skills_to_us': forms.Textarea(attrs={'class': 'form-control'}),
            'in_what_capacity_would_you_be_involved_in': forms.TextInput(attrs={'class': 'form-control'}),
            'would_you_be_interested_in_being_mentored': forms.TextInput(attrs={'class': 'form-control'}),
            'would_you_mentor_others': forms.TextInput(attrs={'class': 'form-control'}),
            'if_interested_what_area_would_you_be_mentored_in': forms.TextInput(attrs={'class': 'form-control'}),
            'list_any_mentors_or_programs': forms.Textarea(attrs={'class': 'form-control'}),
            'do_you_have_existing_affiliations_with_any_creative_society': forms.TextInput(attrs={'class': 'form-control'}),
            'would_you_collaborate': forms.TextInput(attrs={'class': 'form-control'}),
            'would_you_be_interested_with_leadership_roles': forms.TextInput(attrs={'class': 'form-control'}),
            'how_do_you_prefer_to_receive_updates': forms.TextInput(attrs={'class': 'form-control'}),
            'website_or_portfolio': forms.URLInput(attrs={'class': 'form-control'}),
            'facebook': forms.TextInput(attrs={'class': 'form-control'}),
            'instagram': forms.TextInput(attrs={'class': 'form-control'}),
            'youtube': forms.TextInput(attrs={'class': 'form-control'}),
            'other_platforms': forms.TextInput(attrs={'class': 'form-control'}),
            'consent_for_media_use': forms.CheckboxInput(attrs={'class': 'form-check-input'}),
            'code_of_conduct': forms.CheckboxInput(attrs={'class': 'form-check-input'}),
            'commitment_to_the_community': forms.CheckboxInput(attrs={'class': 'form-check-input'}),
        }






class EmailForm(forms.Form):
    full_name = forms.CharField(max_length=100, label='Full Name', required=True)
    from_email = forms.EmailField(label='Email Address', required=True)
    subject = forms.CharField(max_length=200, label='Subject', required=True)
    message = forms.CharField(widget=forms.Textarea, label='Message', required=True)

class CreativeSearchForm(forms.Form):
     keyword = forms.CharField(label='Search by Profession', max_length=100)


# Hire app 


class UserRegistrationForm(forms.ModelForm):
        
        # profession = forms.TextInput()
        # bio = forms.TextInput()
        # phone_number = forms.TextInput()
        # facebook =  forms.TextInput()
        # youtube =  forms.TextInput()
        # twitter =  forms.TextInput()
        # linkedln =  forms.TextInput()
        # website_or_portfolio =  forms.TextInput()
        class Meta:
            model = User
            fields = ['username', 'email', 'password']

class UserProfileForm(forms.ModelForm):
    class Meta:
        model = UserProfile
        fields = ['full_name','profession','address', 'bio', 'phone_number','facebook','youtube','twitter','linkedln','website_or_portfolio','media']
        widgets = {
            'full_name': forms.TextInput(attrs={'class': 'form-control','placeholder':'Your Full Name'}),
            'profession': forms.TextInput(attrs={'class': 'form-control','placeholder':'E.g Web developer, Creative Artist, Visual Artist , Film Maker',}),
            'addresss': forms.TextInput(attrs={'class': 'form-control','placeholder':'E.g Abuja Nigeria',}),
            'bio': forms.Textarea(attrs={'class': 'form-control','placeholder':'Short professional Bio that would be displayed on your profile',}),
            'facebook': forms.TextInput(attrs={'class': 'form-control','placeholder':'www.facebook.com/something',}),
            'phone_number': forms.NumberInput(attrs={'class': 'form-control','placeholder':'+234 90 1234 578 9101'}),
            'youtube': forms.TextInput(attrs={'class': 'form-control','placeholder':'www.youtube.com/something'}),
            'twitter': forms.TextInput(attrs={'class': 'form-control','placeholder':'www.twitter.com/something'}),
            'linkedln': forms.TextInput(attrs={'class': 'form-control','placeholder':'www.linkedln.com/something'}),
            'website_or_portofolio': forms.TextInput(attrs={'class': 'form-control','placeholder':'www.company.com'}),
            # 'media': forms.FileInput(attrs={'class': 'form-control'}),
        }


class CommentForm(forms.ModelForm):
    class Meta:
        model = Comment
        fields = ['name','content','rating']


# class UserFormModelForm(forms.ModelForm):
#     class Meta:
#         model = UserForm
#         fields = [
#             'name',
#             'profession',
        
#             'email',
#             'bio',
#             'project_links',
#             'years_of_experience',
#             'website_or_portfolio',
#             'facebook',
#             'linkedln',
#             'instagram',
#             'youtube',
#             'picture'
#         ]
        
#         widgets = {
#             'name': forms.TextInput(attrs={'class': 'form-control'}),
#             'profession': forms.TextInput(attrs={'class': 'form-control'}),
#             'email': forms.EmailInput(attrs={'class': 'form-control'}),
#             'bio': forms.Textarea(attrs={'rows': 4, 'placeholder': 'Tell us about yourself'}),
#             'project_links': forms.TextInput(attrs={'class': 'form-control'}),
#             'website_or_portfolio': forms.TextInput(attrs={'class': 'form-control'}),
#             'facebook':  forms.TextInput(attrs={'class': 'form-control'}),
#             'linkedln':  forms.TextInput(attrs={'class': 'form-control'}),
#             'instagram':  forms.TextInput(attrs={'class': 'form-control'}),
#             'youtube':  forms.TextInput(attrs={'class': 'form-control'}),
#             'picture': forms.ClearableFileInput(attrs={'accept': 'image/*'}),
#         }


# class CustomUserCreationForm(UserCreationForm):
#     class Meta:
#         model = get_user_model()  # Use the custom user model if you have one
#         fields = ['email', 'password1', 'password2']  # Add other fields as needed
# myapp/forms.py




# class CustomUserCreationForm(UserCreationForm):
#     class Meta:
#         model = CustomUser 
#         fields = ('email', 'first_name', 'last_name', 'profession',
#             'password',
#             'bio',
#             'project_links',
#             'years_of_experience',
#             'website_or_portfolio',
#             'facebook',
#             'linkedln',
#             'instagram',
#             'youtube',
#             'picture',)