# Generated by Django 5.1 on 2024-11-13 02:07

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Blog',
            fields=[
                ('title', models.CharField(max_length=200)),
                ('slug', models.SlugField(blank=True, max_length=200, primary_key=True, serialize=False, unique=True)),
                ('author', models.CharField(max_length=50)),
                ('content', models.TextField()),
                ('published_date', models.DateField(default=django.utils.timezone.now)),
                ('media', models.FileField(blank=True, null=True, upload_to='blog_media/')),
            ],
        ),
        migrations.CreateModel(
            name='CreativeDetails',
            fields=[
                ('full_name', models.CharField(default='Anonymous', max_length=100)),
                ('date_of_birth', models.DateField(blank=True, null=True)),
                ('email', models.EmailField(default='example@example.com', max_length=254, primary_key=True, serialize=False)),
                ('bio', models.TextField(default='about me')),
                ('gender', models.CharField(default='Not Specified', max_length=10)),
                ('phone_number', models.CharField(default='Not Provided', max_length=15)),
                ('address', models.TextField(default='Not Provided')),
                ('parish', models.CharField(default='Not Provided', max_length=100)),
                ('social_media_handles', models.TextField(default='Not Provided')),
                ('diocese', models.CharField(default='Not Specified', max_length=100)),
                ('profile_picture', models.ImageField(default='default.jpg', upload_to='profile_pics/')),
                ('profession', models.CharField(default='Not Specified', max_length=100)),
                ('primary_creative_area', models.CharField(blank=True, default='Not Specified', max_length=50, null=True)),
                ('secondary_creative_area', models.CharField(blank=True, default='None', max_length=50, null=True)),
                ('years_of_experience', models.CharField(default='0-1', max_length=20)),
                ('projects', models.TextField(blank=True, default='Not Provided', null=True)),
                ('freelance_or_professional', models.CharField(default='Freelance', max_length=10)),
                ('why_are_you_joining_us', models.TextField(default='Not Provided')),
                ('what_do_you_want_to_achieve', models.TextField(default='Not Provided')),
                ('what_value_would_your_talent_contribute_to_us', models.TextField(default='Not Provided')),
                ('how_do_you_hope_to_integrate_your_skills_to_us', models.TextField(default='Not Provided')),
                ('in_what_capacity_would_you_be_involved_in', models.CharField(default='Not Specified', max_length=50)),
                ('would_you_be_interested_in_being_mentored', models.CharField(default='No', max_length=10)),
                ('would_you_mentor_others', models.CharField(default='No', max_length=10)),
                ('if_interested_what_area_would_you_be_mentored_in', models.CharField(blank=True, default='None', max_length=100, null=True)),
                ('list_any_mentors_or_programs', models.TextField(blank=True, default='Not Provided', null=True)),
                ('do_you_have_existing_affiliations_with_any_creative_society', models.CharField(blank=True, default='No', max_length=10, null=True)),
                ('would_you_collaborate', models.CharField(default='Yes', max_length=10)),
                ('would_you_be_interested_with_leadership_roles', models.CharField(default='No', max_length=10)),
                ('how_do_you_prefer_to_receive_updates', models.CharField(default='Email', max_length=20)),
                ('website_or_portfolio', models.CharField(blank=True, default='http://example.com', max_length=200, null=True)),
                ('facebook', models.CharField(blank=True, default='http://facebook.com/example', max_length=200, null=True)),
                ('instagram', models.CharField(blank=True, default='http://instagram.com/example', max_length=200, null=True)),
                ('youtube', models.CharField(blank=True, default='http://youtube.com/example', max_length=200, null=True)),
                ('other_platforms', models.TextField(blank=True, default='Not Provided', null=True)),
                ('consent_for_media_use', models.CharField(blank=True, default='No', max_length=10, null=True)),
                ('code_of_conduct', models.CharField(blank=True, default='No', max_length=10, null=True)),
                ('commitment_to_the_community', models.CharField(blank=True, default='No', max_length=10, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Events',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='Anonymous', max_length=100)),
                ('description', models.CharField(default='Anonymous', max_length=100)),
                ('date', models.DateField(null=True)),
                ('time', models.TimeField(null=True)),
                ('media', models.ImageField(blank=True, null=True, upload_to='Events_Media')),
            ],
        ),
        migrations.CreateModel(
            name='UserProfile',
            fields=[
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to=settings.AUTH_USER_MODEL)),
                ('full_name', models.CharField(blank=True, max_length=100)),
                ('address', models.CharField(blank=True, max_length=100)),
                ('profession', models.CharField(blank=True, max_length=100)),
                ('bio', models.TextField(blank=True)),
                ('phone_number', models.CharField(blank=True, max_length=15)),
                ('facebook', models.CharField(blank=True, max_length=50)),
                ('youtube', models.CharField(blank=True, max_length=50)),
                ('twitter', models.CharField(blank=True, max_length=50)),
                ('linkedln', models.CharField(blank=True, max_length=50)),
                ('website_or_portfolio', models.CharField(blank=True, max_length=50)),
                ('media', models.FileField(blank=True, null=True, upload_to='User-image/')),
            ],
        ),
        migrations.CreateModel(
            name='Comment',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=50)),
                ('content', models.TextField()),
                ('rating', models.PositiveIntegerField(blank=True, default=0, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('user_profile', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='comments', to='main.userprofile')),
            ],
        ),
    ]
