from django.urls import path
from django.conf.urls import handler404
from . import views
from django.conf import settings
from django.conf.urls.static import static

urlpatterns = [
    path('', views.home, name='home'),
    path('register/', views.user_form_view, name='register'),
    path('about/', views.about, name='About'),
    path('contact/', views.contact_form, name='contact'),
    path('success-page/', views.user_form_view, name='success-page'),
    path('blog/' , views.Blogs, name='blog'),
    path('blog/<slug:slug>/', views.BlogDetail, name='blog-detail'),
    path('support/' , views.Support, name='support'),
    path('hire-a-creative/' , views.HireACreative, name='hire-a-creative'),
    path('creative-profile/<str:username>/', views.CreativeProfile, name='creative-profile'),
    path('sign-up/', views.CreativeSignUp, name='sign-up'),
    path('delete-profile/', views.delete_profile, name='delete-profile'),
    path('edit-profile/', views.edit_profile, name='edit-profile'),
    path('login/', views.login_view, name='login'),

]

if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)

handler404 = 'main.views.custom_404' 


# Username:	info@catholicreativesng.com
# Password:	Ey3Wl;,cXNFs.
# Incoming Server:	catholicreativesng.com
# IMAP Port: 993 POP3 Port: 995
# Outgoing Server:	catholicreativesng.com
# SMTP Port: 465
# IMAP, POP3, and SMTP require authentication.