from __future__ import print_function
from django.shortcuts import render, get_object_or_404 , redirect
from django.http import HttpResponse
from .models import CreativeDetails ,Blog  , UserProfile , Events ,Comment
from .forms import CreativeDetailsForm , EmailForm , CreativeSearchForm , UserRegistrationForm , UserProfileForm ,CommentForm
from django.db.models import Q
from django.core.mail import send_mail
from django.contrib import messages
from django.template import Context
from django.template.loader import get_template
from django.contrib.auth import login, authenticate
from django.conf import settings 
from postmarker.core import PostmarkClient
from django.template.loader import render_to_string
from django.contrib.auth.decorators import login_required
from django.db.models import Avg
import sib_api_v3_sdk
from sib_api_v3_sdk.rest import ApiException

# home view 
def home(request):
    events = Events.objects.all()
    
    return render(request, 'index.html', {'events':events})



# about view 
def about(request):
    return render(request ,'about.html')

# Search for a creative 



# def find_creative(request):
#     query = request.Get.get('q')
#     if query:
#         q = Q(what_creative_work_do_you_do__icontains=query)
        

# creatives sign up 

def user_form_view(request):
    if request.method == 'POST':
        form = CreativeDetailsForm(request.POST, request.FILES)
        print("Message added: ", messages.get_messages(request))
               
        
        if form.is_valid():
            form.save()  # Save the form data directly to the model
            messages.success(request, 'Form submitted successfully!')
            print("form submitted succesfully")
            # messages.add_message(request, messages.SUCCESS, 'Form submitted successfully!')
            creative = form.instance
            send_creative_confirmation_email(creative)
            return render(request,'success-page.html')
            
        else:
            print("Form not valid")
            # print(form.errors)
            
            
    
        # else:
            # for field in form:
            #     for error in field.errors:
            #         messages.error(request, f"{field.label}: {error}")

        
        

    else:
        
        form = CreativeDetailsForm()
        # messages.error(request, "Invalid Form Submisission Try Again")
       

        
    return render(request, 'users/register.html', {'form': form})

def send_creative_confirmation_email(creative):
    configuration = sib_api_v3_sdk.Configuration()
    configuration.api_key['api-key'] = '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'
    BREVO_API_KEY = "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"
    api_instance = sib_api_v3_sdk.TransactionalEmailsApi(sib_api_v3_sdk.ApiClient(configuration))
    context = {
    'creative': creative,

    'site_name': 'Catholic Creatives NG',
    }
    headers = {
            "accept": "application/json",
            "content-type": "application/json",
            "api-key": BREVO_API_KEY,
        }
    subject = "Thanks for joining Catholic Creatives Nigeria"
    sender = {"name":"Catholic Creatives Nigeria","email":"info@catholiccreativesng.com"}
    replyTo = {"name":creative.full_name,"email":creative.email}
    html_content = render_to_string('emails/confirmation-email.html',context)
    to = [{"email":creative.email,"name":creative.full_name}]
    # params = {"parameter":"My param value","subject":"New Subject"}
    cc_recipients = None  # No CC recipients
    bcc_recipients = None
    send_smtp_email = sib_api_v3_sdk.SendSmtpEmail(to=to, bcc=bcc_recipients, cc=cc_recipients, reply_to=replyTo, headers=headers, html_content=html_content, sender=sender, subject=subject)

    try:
        api_response = api_instance.send_transac_email(send_smtp_email)
        print(api_response)
    except ApiException as e:
        print("Exception when calling SMTPApi->send_transac_email: %s\n" % e)


def contact_form(request):
        form = EmailForm()
        if request.method == 'POST':
            form = EmailForm(request.POST)
            if form.is_valid():
                subject = form.cleaned_data['full_name'] + form.cleaned_data['subject']
                message = form.cleaned_data['message']
                from_email = form.cleaned_data['from_email']
                recipient_list = ['info@fadaben.com']
                
                send_mail(subject, message, from_email, recipient_list)
                return HttpResponse('Email sent successfully')
        else:
             messages.error(request, 'Form invalid. Please try again.')
             form = EmailForm()
             print(form.errors)

    
        return render(request, 'contact.html' , {'form': form})



def Blogs(request):
    posts = Blog.objects.all()
    return render(request, 'blog.html', {'posts': posts})
    



def BlogDetail(request, slug):
    post = get_object_or_404(Blog, slug=slug)
    return render(request,'blog/blog-details.html', {"post":post})




def Support(request):
    return render(request, 'support.html')




def HireACreative(request):
    form = CreativeSearchForm()
    results = []
    # print(form)
    if request.method == 'GET' and 'keyword' in request.GET:
        keyword = request.GET['keyword']
        # Search for creatives by profession or skills
        # results = CreativeDetails.objects.filter(
        #     Q(profession__icontains=keyword) | 
        #     Q(primary_creative_area__icontains=keyword)
        # )
        results = UserProfile.objects.filter(
            Q(profession__icontains=keyword) |
            Q(user__username__icontains=keyword)
           
        )

    return render(request, 'hire-a-creative.html', {'form': form, 'results': results})


def CreativeProfile(request, username):
    comment_form = CommentForm()  # Ensure this is initialized for both GET and POST 
    # requests
    # print(comment_form)
    comments = Comment.objects.all().order_by('-created_at')  # Fetch all comments
    # try:
    user_profile = get_object_or_404(UserProfile, user__username=username)
    comments = Comment.objects.filter(user_profile=user_profile)

    if request.method == 'POST':
         if 'content' in request.POST:
            comment_form = CommentForm(request.POST)
            if comment_form.is_valid():
                comment = comment_form.save(commit=False)
                comment.user_profile = user_profile
                comment.user = request.user
                comment.save()
                return redirect('creative_profile', username=username)

         elif 'reply' in request.POST:  # Check if it's a reply
            parent_comment_id = request.POST.get('parent_comment_id')  # Get the parent comment ID
            parent_comment = get_object_or_404(Comment, id=parent_comment_id)  # Get the parent comment
            reply_form = CommentForm(request.POST)
            if reply_form.is_valid():
                reply = reply_form.save(commit=False)
                reply.user_profile = user_profile
                reply.user = request.user
                reply.parent = parent_comment  # Set the parent comment
                reply.save()
                return redirect('creative_profile', username=username)
            # comment_form = CommentForm(request.POST)
            

            # print(comment_form.errors)
            # print(comment_form)
            # if comment_form.is_valid():
            #     print(comment_form)
            #     print("form saved")
            #     comment = comment_form.save(commit=False)
            #     comment.user_profile = user_profile
            #     comment.user = request.user  # assuming you have user authentication
            #     comment.save()

            
            # else:
            #     print(comment_form.errors)
            # return redirect('creative-profile', username=username)  # Ensure this is the correct URL name
        
    else:
        comment_form = CommentForm()

    context = {
        'creative': user_profile,
        'comments': comments,
        'comment_form': comment_form,
    }
    
    return render(request, 'hire-a-creative/creative-profile.html', context)
    # except Exception as e:
    #      print("An error occurred:", str(e))  # Log the error
    # return render(request, 'hire-a-creative/creative-profile.html')  # Render an error page or handle accordingly
# def CreativeProfile(request, username):
#      user_profile = get_object_or_404(UserProfile, user__username=username)
#      comments = Comment.objects.filter(user_profile=user_profile)
#      ratings = Rating.objects.filter(user_profile=user_profile)
#       # Calculate the average rating
#      average_rating = Rating.objects.filter(user_profile=user_profile).aggregate(Avg('score'))['score__avg']
#     #  average_rating = ratings.aggregate(Avg('score'))['score__avg'] if ratings.exists() else None
#      if request.method == 'POST':
#         if 'comment' in request.POST:
#             comment_form = CommentForm(request.POST)
#             if comment_form.is_valid():
#                 comment = comment_form.save(commit=False)
#                 comment.user_profile = user_profile
#                 comment.user = request.user
#                 comment.save()
#                 return redirect('creative_detail', username=username)
#         elif 'rating' in request.POST:
#             rating_form = RatingForm(request.POST)
#             if rating_form.is_valid():
#                 rating = rating_form.save(commit=False)
#                 rating.user_profile = user_profile
#                 rating.user = request.user
#                 rating.save()
#                 return redirect('creative_detail', username=username)
#      else:
#         comment_form = CommentForm()
#         rating_form = RatingForm()

#         return render(request, 'hire-a-creative/creative-profile.html', {
#             'creative': user_profile,
#             'comments': comments,
#             'ratings': ratings,
#             'comment_form': comment_form,
#             'rating_form': rating_form,
#             'average_rating': average_rating,
#     })
  

def CreativeSignUp(request):
    if request.method == 'POST':
        user_form = UserRegistrationForm(request.POST)
        profile_form = UserProfileForm(request.POST)
       
        if user_form.is_valid() and profile_form.is_valid():
            print()
            user = user_form.save()
            # Automatically log the user in after signup
            login(request, user)

            # Create UserProfile instance with additional data
            user_profile = profile_form.save(commit=False)
            user_profile.user = user  # Link the profile to the newly created user
            user_profile.save()


            # )
            messages.success(request, 'Registration successful! You can now log in.')
            return redirect('creative-profile',username=user.username)
        else:
            print(user_form.errors)
            print(profile_form.errors)
            messages.error(request, 'Please correct the errors below.')
    else:
        user_form = UserRegistrationForm()
        profile_form = UserProfileForm()
        return render(request, 'hire-a-creative/sign-up.html', {'user_form': user_form, 'profile_form':profile_form})
    
@login_required(login_url='/login/')
def delete_profile(request):
    profile = get_object_or_404(UserProfile, user=request.user)
    if request.method == 'POST':
        profile = get_object_or_404(UserProfile, user=request.user)
        profile.delete()
        messages.success(request, 'Profile deleted successfully!')
        return redirect('home')  # Redirect to home or any other page after deletion
    else:
        form = UserProfileForm()
    return render(request, 'hire-a-creative/delete_profile.html', {'form': form, 'profile':profile})

@login_required(login_url='/login/')
def edit_profile(request):
    profile = get_object_or_404(UserProfile, user=request.user)
    if request.method == 'POST':
        form = UserProfileForm(request.POST, instance=profile)
        print(form.errors)
        if form.is_valid():
            form.save()
            messages.success(request, 'Profile updated successfully!')
            return redirect('creative-profile', username=profile.user.username)  # Redirect to the profile page
    else:
        form = UserProfileForm(instance=profile)
    return render(request, 'hire-a-creative/edit_profile.html', {'form': form})



def login_view(request):
    if request.method == 'POST':
        username = request.POST['username']
        password = request.POST['password']
        user = authenticate(request, username=username, password=password)
        if user is not None:
            login(request, user)
            return redirect('creative-profile',username=user.username)  # Redirect to a home page or another page
        else:
            messages.error(request, 'Invalid username or password.')
    return render(request, 'users/login.html')


def custom_404(request, exception):
    return render(request, '404.html', status=404)


#     if request.method == 'POST':

#         form = UserFormModelForm(request.POST, request.FILES)
#         userForm = CustomUserCreationForm(request.POST)
#         print("Message added: ", messages.get_messages(request))
        
#         if form.is_valid() and userForm.is_valid():
#             user = userForm.save()  # Save the form data directly to the model
#             user_form_instance = form.save(commit=False)  # Don't save yet
#             user_form_instance.user = user  # Set the user field
#             user_form_instance.save()  
#             messages.success(request, 'Form submitted successfully!')
#             print("form submitted successfully")
#             login(request, user)
#             return redirect('home')  # Redirect to home after successful signup
            
#         else:
#             print("Form not valid")
#             print(form.errors)
#             print(form.errors)  # Print form errors if any
#             # You may want to add error messages here if needed
            
#     else:
#         form = UserFormModelForm()
#         messages.error(request, "Invalid Form Submission. Try Again.")

#     return render(request, 'users/sign-up.html', {'form': form}, {'user_form': userForm})  # Ensure this return is outside the if-else
