# coding: utf-8

"""
    SendinBlue API

    SendinBlue provide a RESTFul API that can be used with any languages. With this API, you will be able to :   - Manage your campaigns and get the statistics   - Manage your contacts   - Send transactional Emails and SMS   - and much more...  You can download our wrappers at https://github.com/orgs/sendinblue  **Possible responses**   | Code | Message |   | :-------------: | ------------- |   | 200  | OK. Successful Request  |   | 201  | OK. Successful Creation |   | 202  | OK. Request accepted |   | 204  | OK. Successful Update/Deletion  |   | 400  | Error. Bad Request  |   | 401  | Error. Authentication Needed  |   | 402  | Error. Not enough credit, plan upgrade needed  |   | 403  | Error. Permission denied  |   | 404  | Error. Object does not exist |   | 405  | Error. Method not allowed  |   | 406  | Error. Not Acceptable  |   # noqa: E501

    OpenAPI spec version: 3.0.0
    Contact: contact@sendinblue.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from sib_api_v3_sdk.api_client import ApiClient


class ExternalFeedsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_external_feed(self, create_external_feed, **kwargs):  # noqa: E501
        """Create an external feed  # noqa: E501

        This endpoint will create an external feed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_external_feed(create_external_feed, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateExternalFeed create_external_feed: Values to create a feed (required)
        :return: InlineResponse2013
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_external_feed_with_http_info(create_external_feed, **kwargs)  # noqa: E501
        else:
            (data) = self.create_external_feed_with_http_info(create_external_feed, **kwargs)  # noqa: E501
            return data

    def create_external_feed_with_http_info(self, create_external_feed, **kwargs):  # noqa: E501
        """Create an external feed  # noqa: E501

        This endpoint will create an external feed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_external_feed_with_http_info(create_external_feed, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateExternalFeed create_external_feed: Values to create a feed (required)
        :return: InlineResponse2013
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['create_external_feed']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_external_feed" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'create_external_feed' is set
        if ('create_external_feed' not in params or
                params['create_external_feed'] is None):
            raise ValueError("Missing the required parameter `create_external_feed` when calling `create_external_feed`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'create_external_feed' in params:
            body_params = params['create_external_feed']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/feeds', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2013',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_external_feed(self, uuid, **kwargs):  # noqa: E501
        """Delete an external feed  # noqa: E501

        This endpoint will delete an external feed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_external_feed(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: UUID of the feed to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_external_feed_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_external_feed_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def delete_external_feed_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Delete an external feed  # noqa: E501

        This endpoint will delete an external feed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_external_feed_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: UUID of the feed to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_external_feed" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `delete_external_feed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/feeds/{uuid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_external_feeds(self, **kwargs):  # noqa: E501
        """Fetch all external feeds  # noqa: E501

        This endpoint can fetch all created external feeds.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_external_feeds(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str search: Can be used to filter records by search keyword on feed name
        :param date start_date: Mandatory if `endDate` is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Can be maximum 30 days older than current date.
        :param date end_date: Mandatory if `startDate` is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month.
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed.
        :param str auth_type: Filter the records by `authType` of the feed.
        :param int limit: Number of documents returned per page.
        :param int offset: Index of the first document on the page.
        :return: GetAllExternalFeeds
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_external_feeds_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_external_feeds_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_external_feeds_with_http_info(self, **kwargs):  # noqa: E501
        """Fetch all external feeds  # noqa: E501

        This endpoint can fetch all created external feeds.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_external_feeds_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str search: Can be used to filter records by search keyword on feed name
        :param date start_date: Mandatory if `endDate` is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Can be maximum 30 days older than current date.
        :param date end_date: Mandatory if `startDate` is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month.
        :param str sort: Sort the results in the ascending/descending order of record creation. Default order is **descending** if `sort` is not passed.
        :param str auth_type: Filter the records by `authType` of the feed.
        :param int limit: Number of documents returned per page.
        :param int offset: Index of the first document on the page.
        :return: GetAllExternalFeeds
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['search', 'start_date', 'end_date', 'sort', 'auth_type', 'limit', 'offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_external_feeds" % key
                )
            params[key] = val
        del params['kwargs']

        if 'limit' in params and params['limit'] > 500:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_all_external_feeds`, must be a value less than or equal to `500`")  # noqa: E501
        if 'limit' in params and params['limit'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_all_external_feeds`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'search' in params:
            query_params.append(('search', params['search']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('startDate', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('endDate', params['end_date']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'auth_type' in params:
            query_params.append(('authType', params['auth_type']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/feeds', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetAllExternalFeeds',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_external_feed_by_uuid(self, uuid, **kwargs):  # noqa: E501
        """Get an external feed by UUID  # noqa: E501

        This endpoint will update an external feed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_feed_by_uuid(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: UUID of the feed to fetch (required)
        :return: GetExternalFeedByUUID
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_external_feed_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_external_feed_by_uuid_with_http_info(uuid, **kwargs)  # noqa: E501
            return data

    def get_external_feed_by_uuid_with_http_info(self, uuid, **kwargs):  # noqa: E501
        """Get an external feed by UUID  # noqa: E501

        This endpoint will update an external feed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_external_feed_by_uuid_with_http_info(uuid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: UUID of the feed to fetch (required)
        :return: GetExternalFeedByUUID
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_external_feed_by_uuid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `get_external_feed_by_uuid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/feeds/{uuid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetExternalFeedByUUID',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_external_feed(self, uuid, update_external_feed, **kwargs):  # noqa: E501
        """Update an external feed  # noqa: E501

        This endpoint will update an external feed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_external_feed(uuid, update_external_feed, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: UUID of the feed to update (required)
        :param UpdateExternalFeed update_external_feed: Values to update a feed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_external_feed_with_http_info(uuid, update_external_feed, **kwargs)  # noqa: E501
        else:
            (data) = self.update_external_feed_with_http_info(uuid, update_external_feed, **kwargs)  # noqa: E501
            return data

    def update_external_feed_with_http_info(self, uuid, update_external_feed, **kwargs):  # noqa: E501
        """Update an external feed  # noqa: E501

        This endpoint will update an external feed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_external_feed_with_http_info(uuid, update_external_feed, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uuid: UUID of the feed to update (required)
        :param UpdateExternalFeed update_external_feed: Values to update a feed (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uuid', 'update_external_feed']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_external_feed" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uuid' is set
        if ('uuid' not in params or
                params['uuid'] is None):
            raise ValueError("Missing the required parameter `uuid` when calling `update_external_feed`")  # noqa: E501
        # verify the required parameter 'update_external_feed' is set
        if ('update_external_feed' not in params or
                params['update_external_feed'] is None):
            raise ValueError("Missing the required parameter `update_external_feed` when calling `update_external_feed`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uuid' in params:
            path_params['uuid'] = params['uuid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'update_external_feed' in params:
            body_params = params['update_external_feed']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api-key', 'partner-key']  # noqa: E501

        return self.api_client.call_api(
            '/feeds/{uuid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
