from django.db import models
from django.utils import timezone
from django.urls import reverse
from django.utils.text import slugify
import markdown
import uuid
from django.conf import settings 
from django.db import models
from django.contrib.auth.models import AbstractBaseUser , BaseUserManager, PermissionsMixin
from django.contrib.auth.models import User



class CreativeDetails(models.Model):
    full_name = models.CharField(max_length=100, default='Anonymous')
    date_of_birth = models.DateField(null=True, blank=True)  # Allow nulls if not provided
    email = models.EmailField(default='example@example.com' , primary_key=True)  # Default email
    bio = models.TextField(default="about me")
    gender = models.CharField(max_length=10, default='Not Specified')
    phone_number = models.CharField(max_length=15, default='Not Provided')
    address = models.TextField(default='Not Provided')
    parish = models.CharField(max_length=100, default='Not Provided')
    social_media_handles = models.TextField(default='Not Provided')
    diocese = models.CharField(max_length=100, default='Not Specified')
    profile_picture = models.ImageField(upload_to='profile_pics/', default='default.jpg')  # Default profile picture
    profession = models.CharField(max_length=100, default='Not Specified')
    primary_creative_area = models.CharField(max_length=50, default='Not Specified', null=True , blank=True)
    secondary_creative_area = models.CharField(max_length=50, default='None' , null=True , blank=True)
    years_of_experience = models.CharField(max_length=20, default='0-1')
    projects = models.TextField(default='Not Provided' , null=True , blank=True)
    freelance_or_professional = models.CharField(max_length=10, default='Freelance')
    why_are_you_joining_us = models.TextField(default='Not Provided')
    what_do_you_want_to_achieve = models.TextField(default='Not Provided')
    what_value_would_your_talent_contribute_to_us = models.TextField(default='Not Provided')
    how_do_you_hope_to_integrate_your_skills_to_us = models.TextField(default='Not Provided')
    in_what_capacity_would_you_be_involved_in = models.CharField(max_length=50, default='Not Specified')
    would_you_be_interested_in_being_mentored = models.CharField(max_length=10, default='No')
    would_you_mentor_others = models.CharField(max_length=10, default='No')
    if_interested_what_area_would_you_be_mentored_in = models.CharField(max_length=100, default='None'  , null=True , blank=True)
    list_any_mentors_or_programs = models.TextField(default='Not Provided' , null=True , blank=True)
    do_you_have_existing_affiliations_with_any_creative_society = models.CharField(max_length=10, default='No' , null=True , blank=True)
    would_you_collaborate = models.CharField(max_length=10, default='Yes')
    would_you_be_interested_with_leadership_roles = models.CharField(max_length=10, default='No')
    how_do_you_prefer_to_receive_updates = models.CharField(max_length=20, default='Email')
    website_or_portfolio = models.CharField(default='http://example.com'  ,max_length=200 ,null=True , blank=True)
    facebook = models.CharField(default='http://facebook.com/example' ,max_length=200, null=True , blank=True)
    instagram = models.CharField(default='http://instagram.com/example' ,max_length=200, null=True , blank=True)
    youtube = models.CharField(default='http://youtube.com/example' , max_length=200, null=True , blank=True)
    other_platforms = models.TextField(default='Not Provided', null=True , blank=True)
    consent_for_media_use = models.CharField(max_length=10, default='No', null=True , blank=True)
    code_of_conduct = models.CharField(max_length=10, default='No' , null=True , blank=True)
    commitment_to_the_community = models.CharField(max_length=10, default='No' , null=True , blank=True)
    # slug = models.SlugField(unique=True, blank=True, primary_key=True , max_length=200)
    # def save(self, *args, **kwargs):
    #     if not self.slug:
    #         base_slug = slugify(self.full_name)
    #         slug = base_slug
    #         counter = 1
    #         while CreativeDetails.objects.filter(slug=slug).exists():
    #             slug = f"{base_slug}-{counter}"
    #             counter += 1
    #         self.slug = slug
    #     super(CreativeDetails, self).save(*args, **kwargs)

class Blog(models.Model):
    title = models.CharField(max_length=200)
    slug = models.SlugField(max_length=200, unique=True, primary_key=True, blank=True)
    author = models.CharField(max_length=50)
    content = models.TextField()
    published_date = models.DateField(default=timezone.now)
    
    media = models.FileField(upload_to='blog_media/', null=True, blank=True)
    
    def generate_unique_slug(self):
        """Generate a unique slug for new blog posts."""
        base_slug = slugify(self.title)
        unique_slug = base_slug
        counter = 1
        
        # Keep checking until we find a unique slug
        while Blog.objects.filter(slug=unique_slug).exists():
            unique_slug = f"{base_slug}-{counter}"
            counter += 1
            
        return unique_slug
    def save(self, *args, **kwargs):
        if not self.slug:
            self.slug = slugify(self.title)
        super(Blog, self).save(*args, **kwargs)

    def __str__(self):
        return self.title
    
    def get_content_as_html(self):
        return markdown.markdown(self.content)
   
    
    def get_absolute_url(self):
        return reverse('post_detail', args=[self.published_date.strftime('%Y/%m/%d'), self.title.replace(' ', '-')])
    

class Events(models.Model):
    name = models.CharField(max_length=100, default='Anonymous')
    description = models.CharField(max_length=100, default='Anonymous')
    date = models.DateField(null=True)
    time = models.TimeField(null=True)
    media = models.ImageField(upload_to="Events_Media", null=True, blank=True)
    

class UserProfile(models.Model):
    user = models.OneToOneField(User, on_delete=models.CASCADE , primary_key=True)
    full_name = models.CharField(max_length=100, blank=True)
    address = models.CharField(max_length=100, blank=True)
    profession = models.CharField(max_length=100, blank=True)
    bio = models.TextField(blank=True)
    phone_number = models.CharField(max_length=15, blank=True)
    facebook =  models.CharField(max_length=50, blank=True)
    youtube =  models.CharField(max_length=50, blank=True)
    twitter =  models.CharField(max_length=50, blank=True)
    linkedln =  models.CharField(max_length=50, blank=True)
    website_or_portfolio =  models.CharField(max_length=50, blank=True)
    media = models.ImageField(upload_to="User-image/", null=True, blank=True)

    def __str__(self):
        return self.user.username
    
    
class Comment(models.Model):
    user_profile = models.ForeignKey(UserProfile, on_delete=models.CASCADE, related_name='comments')
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    name = models.CharField(max_length=50, blank=True)
    content = models.TextField()
    rating = models.PositiveIntegerField(default=0 , blank=True, null=True)
    created_at = models.DateTimeField(auto_now_add=True)
    # reply = models.CharField(max_length=50, blank=True)
    parent = models.ForeignKey('self', on_delete=models.CASCADE, null=True, blank=True, related_name='replies')


    def __str__(self):
        return f"{self.name} - {self.rating}"

